/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.selection_menu;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.railwayteam.railways.content.custom_bogeys.CategoryIcon;
import com.railwayteam.railways.content.custom_bogeys.selection_menu.BogeyCategoryHandlerClient;
import com.railwayteam.railways.mixin.client.AccessorToolboxHandlerClient;
import com.railwayteam.railways.registry.CRIcons;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Components;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadialBogeyCategoryMenu
extends AbstractSimiScreen {
    private State state;
    private int ticksOpen;
    private int hoveredSlot;
    private boolean scrollMode;
    private int scrollSlot = 0;
    @Nullable
    private ResourceLocation selectedCategory;
    @Nullable
    private Integer favoriteSlot;
    private static final int CENTER = -5;
    private static final int MANAGE_FAVORITES = -7;

    public RadialBogeyCategoryMenu(State state) {
        this.state = state;
        this.hoveredSlot = -1;
    }

    private void renderInInventory(double posX, double posY, int scale, Consumer<RenderInfo> render) {
        MultiBufferSource.BufferSource bufferSource;
        PoseStack modelViewStack;
        block2: {
            modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_85837_(posX, posY, 1050.0);
            modelViewStack.m_85841_(1.0f, 1.0f, -1.0f);
            RenderSystem.m_157182_();
            PoseStack ms = new PoseStack();
            ms.m_85837_(0.0, 0.0, 1000.0);
            ms.m_85841_((float)scale, (float)scale, (float)scale);
            Quaternion zp180 = Vector3f.f_122227_.m_122240_(180.0f);
            Quaternion xRot = Vector3f.f_122223_.m_122240_(-20.0f);
            Quaternion yRot = Vector3f.f_122225_.m_122240_(45.0f);
            zp180.m_80148_(xRot);
            zp180.m_80148_(yRot);
            ms.m_85845_(zp180);
            Lighting.m_166384_();
            bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            try {
                RenderSystem.m_69890_(() -> render.accept(new RenderInfo(ms, bufferSource, 0xF000F0)));
            }
            catch (Exception e) {
                if (!Utils.isDevEnv()) break block2;
                throw e;
            }
        }
        bufferSource.m_109911_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int k;
        int i1;
        float hoveredY;
        float fade = Mth.m_14036_((float)(((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 10.0f), (float)0.001953125f, (float)1.0f);
        this.hoveredSlot = -1;
        Window window = Minecraft.m_91087_().m_91268_();
        float hoveredX = mouseX - window.m_85445_() / 2;
        float distance = hoveredX * hoveredX + (hoveredY = (float)(mouseY - window.m_85446_() / 2)) * hoveredY;
        if (distance > 25.0f && distance < 10000.0f) {
            this.hoveredSlot = Mth.m_14143_((float)(AngleHelper.deg((double)Mth.m_14136_((double)hoveredY, (double)hoveredX)) + 360.0f + 180.0f - 22.5f)) % 360 / 45;
        }
        boolean renderCenterSlot = false;
        if (this.scrollMode && distance > 150.0f) {
            this.scrollMode = false;
        }
        if (renderCenterSlot && distance <= 150.0f) {
            this.hoveredSlot = -5;
        }
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ / 2), 0.0);
        MutableComponent tip = null;
        MutableComponent title = null;
        if (this.favoriteSlot == null && this.selectedCategory != BogeyCategoryHandlerClient.MANAGE_FAVORITES_CATEGORY) {
            if (hoveredX > 60.0f && hoveredX < 100.0f && hoveredY > -20.0f && hoveredY < 20.0f) {
                this.hoveredSlot = -7;
            }
            ms.m_85836_();
            ms.m_85837_((double)(80.0f + -5.0f * (1.0f - fade) * (1.0f - fade)), 0.0, 0.0);
            AllGuiTextures.TOOLBELT_SLOT.render(ms, -12, -12, (GuiComponent)this);
            ms.m_85837_(-0.5, 0.5, 0.0);
            CRIcons.I_FAVORITE.render(ms, -9, -9, (GuiComponent)this);
            ms.m_85837_(0.5, -0.5, 0.0);
            if (!this.scrollMode && this.hoveredSlot == -7) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -13, -13, (GuiComponent)this);
                tip = Components.translatable((String)(this.favoriteSlot == null ? "railways.style_select.manage_favorites" : "railways.style_select.managing_favorites")).m_130940_(ChatFormatting.GOLD);
            }
            ms.m_85849_();
        }
        if (this.favoriteSlot != null) {
            title = Components.translatable((String)"railways.style_select.title.favorites.pick_style").m_130940_(ChatFormatting.LIGHT_PURPLE);
        } else if (this.selectedCategory == BogeyCategoryHandlerClient.MANAGE_FAVORITES_CATEGORY) {
            title = Components.translatable((String)"railways.style_select.title.favorites.pick_slot").m_130940_(ChatFormatting.LIGHT_PURPLE);
        } else if (this.selectedCategory != null) {
            title = Components.translatable((String)"railways.style_select.category").m_7220_((Component)Components.translatable((String)("railways.style_select.category." + this.selectedCategory.m_135827_() + "." + this.selectedCategory.m_135815_()))).m_130940_(ChatFormatting.GOLD);
        }
        for (int slot = 0; slot < 8; ++slot) {
            boolean selected;
            ms.m_85836_();
            double radius = -40.0f + 10.0f * (1.0f - fade) * (1.0f - fade);
            double angle = slot * 45 - 45;
            double angleRad = Math.toRadians(angle + 90.0);
            ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).rotateZ(angle)).translate(0.0, radius, 0.0)).rotateZ(-angle);
            ms.m_85837_(-12.0, -12.0, 0.0);
            boolean bl = selected = slot == (this.scrollMode ? this.scrollSlot : this.hoveredSlot);
            if (this.state == State.PICK_CATEGORY) {
                if (slot < BogeyCategoryHandlerClient.categoryCount()) {
                    ResourceLocation id = BogeyCategoryHandlerClient.getCategoryId(slot);
                    ItemLike icon = (ItemLike)BogeyCategoryHandlerClient.getCategoryIcon(id).get();
                    if (this.f_96541_ != null) {
                        AllGuiTextures.TOOLBELT_SLOT.render(ms, 0, 0, (GuiComponent)this);
                        if (icon instanceof CategoryIcon) {
                            CategoryIcon categoryIcon = (CategoryIcon)icon;
                            this.renderIcon(categoryIcon, ms);
                        } else {
                            GuiGameElement.of((ItemLike)icon).at(3.0f, 3.0f).render(ms);
                        }
                        if (selected) {
                            AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -1, -1, (GuiComponent)this);
                            tip = Components.translatable((String)("railways.style_select.category." + id.m_135827_() + "." + id.m_135815_())).m_130940_(ChatFormatting.GOLD);
                        }
                    }
                } else {
                    AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(ms, 0, 0, (GuiComponent)this);
                }
            } else if (this.state == State.PICK_STYLE) {
                if (slot < BogeyCategoryHandlerClient.styleCount(this.selectedCategory)) {
                    Block block;
                    BogeyStyle style = BogeyCategoryHandlerClient.getStyle(this.selectedCategory, slot);
                    int sizeIdx = this.ticksOpen / 40;
                    BogeySizes.BogeySize size = BogeyCategoryHandlerClient.getSize(this.selectedCategory, slot);
                    if (size == null) {
                        size = ((BogeySizes.BogeySize[])style.validSizes().toArray(BogeySizes.BogeySize[]::new))[sizeIdx % style.validSizes().size()];
                    }
                    if ((block = style.getBlockOfSize(size)) instanceof AbstractBogeyBlock) {
                        AbstractBogeyBlock bogeyBlock = (AbstractBogeyBlock)block;
                        if (this.f_96541_ != null) {
                            double bogeyX = Math.cos(angleRad) * radius;
                            double bogeyY = Math.sin(angleRad) * radius;
                            Consumer<RenderInfo> render = info -> {
                                PoseStack ms2 = info.ms;
                                ms2.m_85836_();
                                BlockState bogeyState = (BlockState)block.m_49966_().m_61124_((Property)AbstractBogeyBlock.AXIS, (Comparable)Direction.Axis.Z);
                                this.f_96541_.m_91289_().m_110912_(bogeyState, ms2, (MultiBufferSource)info.buffers, info.packedLight, OverlayTexture.f_118083_);
                                ms2.m_85849_();
                                bogeyBlock.render(bogeyState, 0.0f, ms2, partialTicks, (MultiBufferSource)info.buffers, info.packedLight, OverlayTexture.f_118083_, style, new CompoundTag());
                            };
                            if (selected) {
                                this.renderInInventory(this.guiLeft - 130, this.guiTop, 30, render);
                                tip = Components.empty().m_7220_(style.displayName).m_130940_(ChatFormatting.GOLD);
                            }
                            if (BogeyCategoryHandlerClient.hasIcon(style, size)) {
                                AllGuiTextures.TOOLBELT_SLOT.render(ms, 0, 0, (GuiComponent)this);
                                this.renderIcon(BogeyCategoryHandlerClient.getIcon(style, size), ms);
                                if (selected) {
                                    AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -1, -1, (GuiComponent)this);
                                }
                            } else {
                                this.renderInInventory((double)this.guiLeft + bogeyX, (double)this.guiTop + bogeyY, selected ? 10 : 8, render);
                            }
                        }
                    }
                } else {
                    AllGuiTextures.TOOLBELT_EMPTY_SLOT.render(ms, 0, 0, (GuiComponent)this);
                }
            }
            ms.m_85849_();
        }
        if (renderCenterSlot) {
            ms.m_85836_();
            AllGuiTextures.TOOLBELT_SLOT.render(ms, -12, -12, (GuiComponent)this);
            AllIcons.I_CONFIG_BACK.render(ms, -9, -9, (GuiComponent)this);
            if (!this.scrollMode && -5 == this.hoveredSlot) {
                AllGuiTextures.TOOLBELT_SLOT_HIGHLIGHT.render(ms, -13, -13, (GuiComponent)this);
                tip = Components.translatable((String)"railways.style_select.back_to_groups").m_130940_(ChatFormatting.GOLD);
            }
            ms.m_85849_();
        }
        if (title != null) {
            i1 = (int)(fade * 255.0f);
            if (i1 > 255) {
                i1 = 255;
            }
            if (i1 > 8) {
                ms.m_85836_();
                ms.m_85837_(0.0, -80.0, 0.0);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                int k1 = 0xFFFFFF;
                k = i1 << 24 & 0xFF000000;
                int l = this.f_96547_.m_92852_((FormattedText)title);
                this.f_96547_.m_92889_(ms, (Component)title, (float)(-l / 2), -4.0f, k1 | k);
                RenderSystem.m_69461_();
                ms.m_85849_();
            }
        }
        ms.m_85849_();
        if (tip != null) {
            i1 = (int)(fade * 255.0f);
            if (i1 > 255) {
                i1 = 255;
            }
            if (i1 > 8) {
                ms.m_85836_();
                ms.m_85837_((double)(this.f_96543_ / 2), (double)(this.f_96544_ - 68), 0.0);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                int k1 = 0xFFFFFF;
                k = i1 << 24 & 0xFF000000;
                int l = this.f_96547_.m_92852_((FormattedText)tip);
                this.f_96547_.m_92889_(ms, (Component)tip, (float)(-l / 2), -4.0f, k1 | k);
                RenderSystem.m_69461_();
                ms.m_85849_();
            }
        }
    }

    private void renderIcon(CategoryIcon categoryIcon, PoseStack ms) {
        this.renderIcon(categoryIcon.location, ms);
    }

    private void renderIcon(ResourceLocation location, PoseStack ms) {
        ms.m_85836_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        GuiComponent.m_93143_((PoseStack)ms, (int)3, (int)3, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        ms.m_85849_();
    }

    public void m_96558_(@NotNull PoseStack ms, int vOffset) {
        int a = (int)(80.0f * Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f)) << 24;
        this.m_93179_(ms, 0, 0, this.f_96543_, this.f_96544_, 0x101010 | a, 0x101010 | a);
    }

    public void m_86600_() {
        if (this.state == State.PICK_STYLE && this.selectedCategory == null) {
            this.state = State.PICK_CATEGORY;
        }
        ++this.ticksOpen;
        super.m_86600_();
    }

    public boolean m_6375_(double x, double y, int button) {
        int selected;
        int n = selected = this.scrollMode ? this.scrollSlot : this.hoveredSlot;
        if (button == 0) {
            if (selected == -7) {
                this.state = State.PICK_STYLE;
                this.selectedCategory = BogeyCategoryHandlerClient.MANAGE_FAVORITES_CATEGORY;
                return true;
            }
            if (this.state == State.PICK_CATEGORY && selected >= 0 && selected < BogeyCategoryHandlerClient.categoryCount()) {
                this.state = State.PICK_STYLE;
                this.selectedCategory = BogeyCategoryHandlerClient.getCategoryId(selected);
                return true;
            }
            if (this.state == State.PICK_STYLE && this.selectedCategory == BogeyCategoryHandlerClient.MANAGE_FAVORITES_CATEGORY) {
                this.state = State.PICK_CATEGORY;
                this.favoriteSlot = selected;
                this.selectedCategory = null;
                return true;
            }
            if (this.state == State.PICK_STYLE && selected >= 0 && selected < BogeyCategoryHandlerClient.styleCount(this.selectedCategory)) {
                BogeyStyle style = BogeyCategoryHandlerClient.getStyle(this.selectedCategory, selected);
                BogeySizes.BogeySize size = BogeyCategoryHandlerClient.getSize(this.selectedCategory, selected);
                if (this.favoriteSlot != null) {
                    if (BogeyCategoryHandlerClient.getFavorites().size() <= this.favoriteSlot) {
                        BogeyCategoryHandlerClient.getFavorites().add(style);
                    } else {
                        BogeyCategoryHandlerClient.getFavorites().remove(this.favoriteSlot);
                        BogeyCategoryHandlerClient.getFavorites().add(this.favoriteSlot, style);
                    }
                    BogeyCategoryHandlerClient.optimizeFavorites();
                } else {
                    BogeyCategoryHandlerClient.setSelectedStyle(style, size);
                }
                this.m_7379_();
                BogeyCategoryHandlerClient.COOLDOWN = 2;
                AccessorToolboxHandlerClient.setCOOLDOWN(2);
                return true;
            }
        }
        if (button == 1 && this.state == State.PICK_STYLE && this.selectedCategory != BogeyCategoryHandlerClient.MANAGE_FAVORITES_CATEGORY) {
            this.state = State.PICK_CATEGORY;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        double hoveredY;
        Window window = Minecraft.m_91087_().m_91268_();
        double hoveredX = mouseX - (double)(window.m_85445_() / 2);
        double distance = hoveredX * hoveredX + (hoveredY = mouseY - (double)(window.m_85446_() / 2)) * hoveredY;
        if (distance <= 150.0) {
            this.scrollMode = true;
            this.scrollSlot = ((int)((double)this.scrollSlot - delta) + 8) % 8;
            for (int i = 0; !(i >= 10 || this.state == State.PICK_CATEGORY && this.scrollSlot < BogeyCategoryHandlerClient.categoryCount() || this.state == State.PICK_STYLE && this.scrollSlot < BogeyCategoryHandlerClient.styleCount(this.selectedCategory)); ++i) {
                this.scrollSlot -= Mth.m_14205_((double)delta);
                this.scrollSlot = (this.scrollSlot + 8) % 8;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7920_(int code, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)code, (int)scanCode);
        if (Utils.isActiveAndMatches(AllKeys.TOOL_MENU.getKeybind(), mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7920_(code, scanCode, modifiers);
    }

    static enum State {
        PICK_CATEGORY,
        PICK_STYLE;

    }

    private record RenderInfo(PoseStack ms, MultiBufferSource.BufferSource buffers, int packedLight) {
    }
}

